/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.

 */

#include <sys/types.h>
#include <stdio.h>
#include "pgplib.h"
#include <md5.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

char *Progname;

void
usage()
{
    fprintf(stderr,
	    "usage: %s file\n",
	    Progname);
    exit(1);
}

int
main(int argc, char *argv[])
{
    int 	i;
    int		fd;
    u_char	*buf;
    char	*filename;
    PGPliteral_t literal;

    if ( argc != 2 )
	usage();

    i = create_literal(argv[1], &literal);
    if ( i != 0 ) {
	fprintf(stderr, "Cound not create literal struct\n");
	exit(1);
    }

    fprintf(stderr, "data = %d\n", literal.datalen);
    fprintf(stderr, "Length is %d\n", literal.length);

    /* Do this twice to be sure */
    i = literal_to_buf(&literal, &buf);
    if ( i != 0 ) {
	fprintf(stderr, "Cound not create literal packet\n");
	exit(1);
    }
    fd = literal.length;
    free_literal(&literal);

    i = parse_literal_buffer(buf, fd, &literal);
    fprintf(stderr, "data = %d\n", literal.datalen);
    fprintf(stderr, "Length is now %d\n", literal.length);

    memset(buf, 0, literal.length);
    free(buf);

    i = literal_to_buf(&literal, &buf);
    if ( i != 0 ) {
	fprintf(stderr, "Cound not create literal packet\n");
	exit(1);
    }

    i = strlen(argv[1]);
    filename = calloc(1, i+5);
    if ( filename == NULL ) {
	fprintf(stderr, "Out of memory\n");
	exit(1);
    }
    strcat(filename, argv[1]);
    strcat(filename, ".pgp");
    
    fd = open(filename, O_WRONLY|O_CREAT|O_TRUNC, 0600);
    if ( fd < 0 ) {
	perror(filename);
	return(1);
    }
    write(fd, buf, literal.length);
    close(fd);

    exit(0);
}

    
    
