/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.


 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <malloc.h>

int verbose = 1;

#include "shell.h"
#include <pgplib.h>

static struct {
  void    (*command)(int ,char* [] );
  char    *name;
  char    *doc;  /* NULL when help info should not be printed */
} cmdtbl[] = {
    { add,	"ADD",		"ADD file [armor]: add keys and/or certificates"},
    { base_open,"DBOPEN",	"DBOPEN name [force|write]: open name as a database"},
    { get_key,	"GET",		"GET [0x12345678 | 0x1234567890123456 | Foo Bar]"},
    { help,	"HELP",		"HELP: list the commands"},
    { quit,	"QUIT",		"QUIT: (guess what)"},
    { scan, 	"SCAN",		"SCAN file [armor]"},
    { verify,	"VERIFY", 	"VERIFY 0x1234567890123456"},
    { NULL, 	NULL, 		NULL}
};

void
help(int argc, char *argv[])
{
    int 	i;

    switch (argc) {
    case 1:
	for( i=0; cmdtbl[i].name; i++ )
	    fprintf(stdout, "\t%s\t%s\n", cmdtbl[i].name, cmdtbl[i].doc);
	return;
    case 2:
	for( i=0; cmdtbl[i].name; i++ )
	    if ( ! strcasecmp(cmdtbl[i].name, argv[1])) {
		fprintf(stdout, "\t%s\t%s\n", cmdtbl[i].name, cmdtbl[i].doc);
		return;
	    }
	fprintf(stdout, "HELP: %s: Unknown command (try HELP)\n", argv[1]);
	return;
    default:
	for(i=0; cmdtbl[i].command != NULL; i++)
	    fprintf(stdout, "\t%s\t%s\n", cmdtbl[i].name, cmdtbl[i].doc);
    }
}

void
quit(int argc, char *argv[])
{
    keydb_end();
    exit(0);
}

char 	Arg[MAXLINE];

void
main(void)
{
    char 	line[MAXLINE];
    char 	*p, *val, **commands, **tmp;
    int 	num_arg, i;
    void 	(*func)(int, char* []);
    
    commands = NULL;
    fprintf(stdout, PROMPT);
    while ( fgets(line, MAXLINE, stdin) != NULL ) {
	
	/* free(NULL) is OK */
	if ( commands != NULL)
	    free(commands);
	commands = 0;
	
	p = rindex(line, '\n');
	assert(*p == '\n');
	*p = NULL;

	/* Keep a copy of the arguments on the command line */
	strncpy(Arg, line, MAXLINE);

	num_arg = 0;
	p = line;
	while(p != NULL ) {
	    while ( (val = strsep(&p, " \t")) != NULL && *val == '\0') 
		/*void*/;
	    if ( val == NULL )
		break;
	    if ( commands == NULL )
		tmp = calloc ((num_arg+1) * sizeof(char *), 1);
	    else
		tmp = realloc (commands, (num_arg+1) * sizeof(char *));
	    if ( tmp == NULL ) {
		fprintf(stderr, "Out of memory\n");
		exit(1);
	    }
	    commands = tmp;
	    commands[num_arg] = val;
	    num_arg += 1;
	}
	func = NULL;
	for( i=0; cmdtbl[i].name; i++ )
	    if ( ! strcasecmp(cmdtbl[i].name, commands[0])) {
		func = cmdtbl[i].command;
		break;
	    }
	if ( func == NULL ) {
	    fprintf(stderr, "Unknown command: %s (try HELP)\n", commands[0]);
	    fprintf(stdout, PROMPT);
	    continue;
	}
	else
	    (*func)(num_arg, commands);
	fprintf(stdout, PROMPT);

    }
    /* End of commands */
    quit(0, NULL);
}
	
